using log4net;
using Microsoft.Azure.WebJobs;
using Microsoft.Azure.WebJobs.Extensions.Http;
using System;
using System.Net;
using System.Net.Http;
using System.Threading.Tasks;
using VA.PPMS.Context;
using VA.PPMS.IWS.BatchService.Interface;
using VA.PPMS.IWS.Common;
using VA.PPMS.IWS.QueueService.Interface;

namespace VA.PPMS.IWS.Functions
{
    public static class CcnInitialDocRef
    {
        [FunctionName("CcnInitialDocRef")]
        public static async Task<HttpResponseMessage> Run([HttpTrigger(AuthorizationLevel.Anonymous, "post", Route = "CcnInitialDocRef/v1")]HttpRequestMessage req,
            [Inject]IQueueService queueService,
            [Inject]IBatchService batchService,
            [Inject] ILog logger)
        {
            try
            {
                logger.Info("@@@@@ Start CcnInitialDocRef http function @@@@@");

                var payload = await req.Content.ReadAsStringAsync();
                var message = new DasMessage(payload);

                if (await queueService.PutProviderQueueAsync(payload)) await batchService.CreateBatch(message, "Initial DocumentReference received", (int)ppms_batch_StatusCode.RequestInitiated);
                else await batchService.CreateBatch(message, "Unable to add DocumentReference to queue", (int)ppms_batch_StatusCode.Failed);

                logger.Info("@@@@@ End CcnInitialDocRef http function @@@@@");

                return req.CreateResponse(HttpStatusCode.Created);
            }
            catch (Exception ex)
            {
                logger.Error("An error occurred in the CcnInitialDocRef Function API: ", ex);
                return req.CreateErrorResponse(HttpStatusCode.InternalServerError, "An error occurred in the CcnInitialDocRef Function API: ", ex);
            }
        }
    }
}